<?php
// File: loading.php
// Animasi loading untuk transisi halaman
?>
<style>
    #loading-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: white;
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
        transition: opacity 0.5s ease-in-out;
        opacity: 0;
        visibility: hidden;
    }
    #loading-overlay.visible {
        opacity: 1;
        visibility: visible;
    }
    .loader {
        width: 60px;
        height: 60px;
        border: 5px solid #000;
        border-bottom-color: transparent;
        border-radius: 50%;
        display: inline-block;
        box-sizing: border-box;
        animation: rotation 1s linear infinite;
    }
    @keyframes rotation {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>
<div id="loading-overlay">
    <span class="loader"></span>
</div>
<script>
    const loadingOverlay = document.getElementById('loading-overlay');
    
    // Tampilkan loading saat navigasi dimulai
    document.addEventListener('DOMContentLoaded', () => {
        document.querySelectorAll('a').forEach(link => {
            link.addEventListener('click', (event) => {
                if (link.href && link.target !== '_blank' && !link.href.startsWith('#')) {
                    loadingOverlay.classList.add('visible');
                }
            });
        });

        // Sembunyikan loading saat halaman dimuat
        window.addEventListener('load', () => {
            loadingOverlay.classList.remove('visible');
        });
    });
</script>