<?php
// File: login.php
// Halaman login admin
include 'db.php';
$message = '';

// Tangani form login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    $user = checkUserLogin($username, $password);

    if ($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_role'] = $user['role'];
        if ($_SESSION['user_role'] === 'admin') {
            header('Location: admin.php');
            exit;
        } else {
            header('Location: user.php');
            exit;
        }
    } else {
        $message = 'Username atau password salah, atau akun Anda belum disetujui oleh admin.';
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin - yapping.</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400..900;1,400..900&display=swap" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;700&display=swap');
        body {
            font-family: 'Inter', sans-serif;
            background-color: #fff;
            color: #000;
        }
        .title-font {
            font-family: 'Playfair Display', serif;
        }
        #loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: white;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            transition: opacity 0.5s ease-in-out;
            opacity: 0;
            visibility: hidden;
        }
        #loading-overlay.visible {
            opacity: 1;
            visibility: visible;
        }
        .loader {
            width: 60px;
            height: 60px;
            border: 5px solid #000;
            border-bottom-color: transparent;
            border-radius: 50%;
            display: inline-block;
            box-sizing: border-box;
            animation: rotation 1s linear infinite;
        }
        @keyframes rotation {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body class="bg-white text-black p-4 sm:p-8 md:p-12 min-h-screen flex flex-col">
    <div id="loading-overlay">
        <span class="loader"></span>
    </div>
    <header class="flex items-center justify-between mb-12">
        <h1 class="text-4xl sm:text-5xl md:text-6xl font-bold title-font">yapping.</h1>
    </header>
    <main class="max-w-md mx-auto flex-grow">
        <a href="index.php" class="text-black font-bold mb-8 inline-block hover:underline">&larr; Kembali</a>
        <div class="mt-8 bg-gray-100 border border-gray-300 rounded-xl p-6 shadow-lg text-center">
            <h1 class="text-3xl sm:text-4xl font-bold mb-8">Login Admin</h1>

            <?php if ($message): ?>
                <div class="bg-red-700 text-white p-4 rounded-lg mb-4"><?php echo htmlspecialchars($message); ?></div>
            <?php endif; ?>

            <form action="login.php" method="POST">
                <div class="mb-4">
                    <input type="text" name="username" class="bg-white text-black border-gray-300 rounded-md p-3 w-full focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent" placeholder="Username" required>
                </div>
                <div class="mb-6">
                    <input type="password" name="password" class="bg-white text-black border-gray-300 rounded-md p-3 w-full focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent" placeholder="Password" required>
                </div>
                <button type="submit" class="w-full bg-black text-white font-bold py-3 px-4 rounded-lg hover:bg-gray-800 transition duration-300">
                    Masuk
                </button>
            </form>
            <div class="mt-6">
                <p class="text-gray-600">Belum punya akun? <a href="register.php" class="text-black font-semibold hover:underline">Daftar di sini</a></p>
            </div>
        </div>
    </main>
    <footer class="text-center text-gray-500 mt-12 text-sm">
        <p>Hak Cipta &copy; <?php echo date('Y'); ?>. nido.</p>
    </footer>
    <script>
        const loadingOverlay = document.getElementById('loading-overlay');
        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('a').forEach(link => {
                link.addEventListener('click', (event) => {
                    if (link.href && link.target !== '_blank' && !link.href.startsWith('#')) {
                        loadingOverlay.classList.add('visible');
                    }
                });
            });

            window.addEventListener('load', () => {
                loadingOverlay.classList.remove('visible');
            });
        });
    </script>
</body>
</html>