<?php
// File: post.php
// Tampilan detail postingan dengan proteksi PIN
include 'db.php';
include 'header.php';

$postId = $_GET['id'] ?? '';
$post = getPostById($postId);

if (!$post) {
    die('<div class="text-center text-red-500 p-8">Postingan tidak ditemukan.</div>');
}
?>
    <style>
        .prose p {
            word-wrap: break-word;
            overflow-wrap: break-word;
        }
    </style>
    <main class="max-w-4xl mx-auto flex-grow">
        <a href="index.php" class="text-black font-bold mb-8 inline-block hover:underline">&larr; Kembali</a>
        
        <?php if (!empty($post['pin'])): ?>
            <div id="pin-container" class="bg-gray-100 border border-gray-300 rounded-xl p-6 shadow-lg">
                <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-4 text-left"><?php echo htmlspecialchars($post['title']); ?></h1>
                <?php if (!empty($post['image'])) { ?>
                    <div class="mb-6">
                        <img src="<?php echo htmlspecialchars($post['image']); ?>" alt="<?php echo htmlspecialchars($post['title']); ?>" class="w-full h-auto rounded-lg object-cover">
                    </div>
                <?php } ?>
                <div class="prose text-gray-700 mb-8">
                    <p class="text-justify" style="overflow-wrap: break-word; word-break: break-all;"><?php echo nl2br(htmlspecialchars(substr($post['content'], 0, 25))); ?>...</p>
                </div>
                <h2 class="text-xl sm:text-2xl font-bold mb-4 text-center">Masukkan PIN untuk membaca selengkapnya</h2>
                <div class="text-center">
                    <input type="password" id="pin-input" class="bg-white text-black border-gray-300 rounded-md p-3 text-center w-full max-w-xs" placeholder="Masukkan PIN">
                    <button onclick="checkPin('<?php echo htmlspecialchars($post['pin']); ?>')" class="mt-4 bg-black text-white font-bold py-3 px-6 rounded-lg hover:bg-gray-800 transition duration-300">
                        Buka Postingan
                    </button>
                </div>
                <p id="pin-message" class="text-red-600 mt-2 text-center"></p>
            </div>
            
            <div id="full-content" class="hidden mt-8 bg-gray-100 border border-gray-300 rounded-xl p-6 shadow-lg">
                <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-4 text-left"><?php echo htmlspecialchars($post['title']); ?></h1>
                <?php if (!empty($post['image'])) { ?>
                    <div class="mb-6">
                        <img src="<?php echo htmlspecialchars($post['image']); ?>" alt="<?php echo htmlspecialchars($post['title']); ?>" class="w-full h-auto rounded-lg object-cover">
                    </div>
                <?php } ?>
                <div class="prose text-gray-700">
                    <p class="text-justify"><?php echo nl2br(htmlspecialchars($post['content'])); ?></p>
                </div>
            </div>
        <?php else: ?>
            <div id="full-content" class="mt-8 bg-gray-100 border border-gray-300 rounded-xl p-6 shadow-lg">
                <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-4 text-left"><?php echo htmlspecialchars($post['title']); ?></h1>
                <?php if (!empty($post['image'])) { ?>
                    <div class="mb-6">
                        <img src="<?php echo htmlspecialchars($post['image']); ?>" alt="<?php echo htmlspecialchars($post['title']); ?>" class="w-full h-auto rounded-lg object-cover">
                    </div>
                <?php } ?>
                <div class="prose text-gray-700">
                    <p class="text-justify"><?php echo nl2br(htmlspecialchars($post['content'])); ?></p>
                </div>
            </div>
        <?php endif; ?>
    </main>
    <script>
        function checkPin(correctPin) {
            const userInput = document.getElementById('pin-input').value;
            const messageElement = document.getElementById('pin-message');
            const fullContent = document.getElementById('full-content');
            const pinContainer = document.getElementById('pin-container');
            const loadingOverlay = document.getElementById('loading-overlay');

            if (userInput === correctPin) {
                loadingOverlay.classList.add('visible');
                
                setTimeout(() => {
                    pinContainer.style.display = 'none';
                    fullContent.style.display = 'block';
                    messageElement.textContent = '';
                    loadingOverlay.classList.remove('visible');
                }, 500); 
                
            } else {
                messageElement.textContent = 'PIN salah, silakan coba lagi.';
                document.getElementById('pin-input').value = '';
            }
        }
    </script>
<?php
include 'footer.php';
?>