<?php
// File: register.php
// Halaman pendaftaran pengguna
include 'db.php';

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $full_name = $_POST['full_name'] ?? '';
    $password = $_POST['password'] ?? '';

    $result = registerUser($username, $full_name, $password);
    if ($result === true) {
        $message = 'Pendaftaran berhasil! Akun Anda akan segera diverifikasi oleh admin.';
    } else {
        $error = $result;
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Akun - yapping.</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400..900;1,400..900&display=swap" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;700&display=swap');
        body {
            font-family: 'Inter', sans-serif;
            background-color: #fff;
            color: #000;
        }
        .title-font {
            font-family: 'Playfair Display', serif;
        }
        #loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: white;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            transition: opacity 0.5s ease-in-out;
            opacity: 0;
            visibility: hidden;
        }
        #loading-overlay.visible {
            opacity: 1;
            visibility: visible;
        }
        .loader {
            width: 60px;
            height: 60px;
            border: 5px solid #000;
            border-bottom-color: transparent;
            border-radius: 50%;
            display: inline-block;
            box-sizing: border-box;
            animation: rotation 1s linear infinite;
        }
        @keyframes rotation {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body class="bg-white text-black p-4 sm:p-8 md:p-12 min-h-screen flex flex-col">
    <div id="loading-overlay">
        <span class="loader"></span>
    </div>
    <header class="flex items-center justify-between mb-12">
        <h1 class="text-4xl sm:text-5xl md:text-6xl font-bold title-font">yapping.</h1>
        <a href="index.php" class="bg-black text-white px-6 py-2 rounded-full font-semibold hover:bg-gray-800 transition duration-300">
            Kembali ke Blog
        </a>
    </header>
    <main class="max-w-md mx-auto flex-grow">
        <a href="login.php" class="text-black font-bold mb-8 inline-block hover:underline">&larr; Kembali</a>
        <div class="mt-8 bg-gray-100 border border-gray-300 rounded-xl p-6 shadow-lg text-center">
            <h1 class="text-3xl sm:text-4xl font-bold mb-8">Daftar Akun Baru</h1>

            <?php if ($message): ?>
                <div class="bg-green-700 text-white p-4 rounded-lg mb-4"><?php echo htmlspecialchars($message); ?></div>
            <?php endif; ?>
            <?php if ($error): ?>
                <div class="bg-red-700 text-white p-4 rounded-lg mb-4"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>

            <form action="register.php" method="POST">
                <div class="mb-4">
                    <input type="text" name="username" class="bg-white text-black border-gray-300 rounded-md p-3 w-full focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent" placeholder="Username" required>
                </div>
                <div class="mb-4">
                    <input type="text" name="full_name" class="bg-white text-black border-gray-300 rounded-md p-3 w-full focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent" placeholder="Nama Lengkap" required>
                </div>
                <div class="mb-6">
                    <input type="password" name="password" class="bg-white text-black border-gray-300 rounded-md p-3 w-full focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent" placeholder="Password" required>
                </div>
                <button type="submit" class="w-full bg-black text-white font-bold py-3 px-4 rounded-lg hover:bg-gray-800 transition duration-300">
                    Daftar
                </button>
            </form>
        </div>
    </main>
    <footer class="text-center text-gray-500 mt-12 text-sm">
        <p>Hak Cipta &copy; <?php echo date('Y'); ?>. nido.</p>
    </footer>
    <script>
        function showToast(message, bgColor) {
            const toast = document.createElement('div');
            toast.className = `fixed bottom-4 right-4 text-white px-6 py-3 rounded-lg shadow-xl ${bgColor} z-50 transition-transform transform translate-y-full`;
            toast.textContent = message;
            document.body.appendChild(toast);

            setTimeout(() => {
                toast.style.transform = 'translateY(0)';
            }, 100);

            setTimeout(() => {
                toast.style.transform = 'translateY(100%)';
                toast.addEventListener('transitionend', () => {
                    toast.remove();
                });
            }, 3000);
        }

        window.addEventListener('load', function() {
            const successMessage = document.querySelector('.bg-green-700');
            if (successMessage) {
                showToast(successMessage.textContent, 'bg-green-700');
                successMessage.style.display = 'none';
            }
            const errorMessage = document.querySelector('.bg-red-700');
            if (errorMessage) {
                showToast(errorMessage.textContent, 'bg-red-700');
                errorMessage.style.display = 'none';
            }
        });
        
        const loadingOverlay = document.getElementById('loading-overlay');
        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('a').forEach(link => {
                link.addEventListener('click', (event) => {
                    if (link.href && link.target !== '_blank' && !link.href.startsWith('#')) {
                        loadingOverlay.classList.add('visible');
                    }
                });
            });

            window.addEventListener('load', () => {
                loadingOverlay.classList.remove('visible');
            });
        });
    </script>
</body>
</html>